<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fpaexp="http://bosch.com/fpaexport/XSLT">
  <xsl:output method="xml" indent="no"/>
  <xsl:param name="ExportFiles">ExportFiles.xml</xsl:param>
  <!--##############  BEGIN Namspace fpaexp   ####################-->
  <fpaexp:Stylesheet version="$Revision: 1.4 $"/>
  <!--##############  END Namspace fpaexp   ####################-->
  <xsl:template match="*">
    <xsl:element name="{name()}">
      <xsl:apply-templates select="@* | node()"/>
    </xsl:element>
  </xsl:template>
  <!-- explicitly copy attributes -->
  <xsl:template match="@*">
    <xsl:copy/>
  </xsl:template>
  <xsl:template match="NodeEntry">
    <xsl:element name="{name()}">
      <xsl:for-each select="@*">
        <xsl:attribute name="{name()}"><xsl:value-of select="."/></xsl:attribute>
      </xsl:for-each>
      <xsl:apply-templates select="NodeInfo"/>
      <xsl:choose>
        <xsl:when test="LocalData = true()">
          <xsl:apply-templates select="LocalData"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="NodeID" select="@nodeID"/>
          <xsl:variable name="ExportFile">
            <xsl:value-of select="document($ExportFiles)//path[@ID = $NodeID]"/>
          </xsl:variable>
          <xsl:apply-templates select="document($ExportFile)//LocalData"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>
</xsl:stylesheet>
